//
//  MCQueryElementView.h
//  MCApplication
//
//  Created by Michael Clark on 16/08/04.
//  Copyright 2004 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCView.h"
#import "MCCollapsibleSheetWidget.h"


@class MCQueryCriteria;
@class MCQueryElementSubView;
@class MCPDocument;


@interface MCQueryElementView : MCCollapsibleSheetWidget {
	MCQueryCriteria*       _criteria;
	NSDictionary*          _config;
	NSString*              _entityName;
	
	/// Size Caching
	float               _preferredHeight;
	
	
	MCPDocument*   __document;
}


- (id)initWithFrame: (NSRect)aFrame document: (MCPDocument*)aDocument criteria: (MCQueryCriteria*)aCriteria config: (NSDictionary*)aConfig entityName: (NSString*)entityName;

- (NSDictionary*)viewConfig;



- (MCQueryCriteria *)criteria;
- (void)setCriteria:(MCQueryCriteria *)aCriteria;

- (NSDictionary *)config;
- (void)setConfig:(NSDictionary *)aConfig;

- (MCPDocument *)document;
- (void)setDocument:(MCPDocument *)aDocument;

- (NSString *)entityName;
- (void)setEntityName:(NSString *)anEntityName;

@end
